# Script for calculation of domain coordination

library(dplyr)
library(readr)

#setwd("C:/Users/Andreas Kolbeck/Google Drive/PhD/Project #1_Characterisation of LOTR1/Casparian Strip domain coordination/")
setwd("G:/My Drive/PhD/Paper with Peter/nice pictures/double membrane/Coordination analysis/")


# Load pixel value from binarized images for measurements (binarized or non-binarized):
sample_a <- read_csv("Col-0_1.csv")
sample_b <- read_csv("Col-0_2.csv")

colnames(sample_a) <- c("pixel","value") # rename columns
sample_a$membrane <- c("mem1")           # attach membrane ID value

colnames(sample_b) <- c("pixel","value") # rename columns
sample_b$membrane <- c("mem2")           # attach membrane ID value

mysample <- sample_a[,1:2]    # binding samples into single data frame:
mysample$mem2 <- sample_b$value

colnames(mysample) <- c("pixel","mem1", "mem2")

mysample <- mysample %>%
  mutate(diff = sqrt((mem1-mem2)^2))

# ******************************************************************************************************************
# Statistics

plot(diff~pixel, mysample)
plot(mem1~mem2, mysample)


cor.test(mysample$mem1, mysample$mem2, method = "kendall")
